<?php
/*--------------------------------------------------------------
   ProductVariantFilters.php 2020-03-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ProductVariant\App\Data\Filter;

use Gambio\Core\Filter\SqlFilters;

/**
 * Class ProductVariantFilters
 * @package Gambio\Admin\Modules\ProductVariant\App\Data\Filter
 */
class ProductVariantFilters extends SqlFilters
{
    
    /**
     * @inheritDoc
     */
    public static function attributeColumnMapping(): array
    {
        return [
            'id'             => 'products_properties_combis_values_id',
            'combination'    => 'combination', // example value 1-1|2-4
            'sortOrder'      => 'sort_order',
            'modelNumber'    => 'combi_model',
            'GTIN'           => 'gtin',
            'ASIN'           => 'asin',
            'EAN'            => 'combi_ean',
            'stockType'      => 'combi_quantity_type', // todo: add to DB table
            'stock'          => 'combi_quantity',
            'weightType'     => 'combi_weight_type',
            'weight'         => 'combi_weight',
            'priceType'      => 'combi_price_type',
            'price'          => 'combi_price',
            'vpeScalarValue' => 'vpe_value',
            'vpeUnitId'      => 'products_vpe_id',
            'deliveryTimeId' => 'combi_shipping_status_id',
            'imageListId'    => 'product_image_list_id',
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public static function attributesForLikeOperation(): array
    {
        return [
            'id',
            'modelNumber',
            'GTIN',
            'ASIN',
            'EAN',
            'stockType',
            'weightType',
            'priceType',
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public static function attributesForNumericOperations(): array
    {
        return [
            'combination',
            'sortOrder',
            'stock',
            'weight',
            'price',
            'vpeScalarValue',
            'vpeUnitId',
            'deliveryTimeId',
            'imageListId',
        ];
    }
}